/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.hmmdecode;

import se.ki.cgb.labeledhmm.LabeledOutputHandler;

/**
 * Class to print phobius short output
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
public class LongOutputHandler extends LabeledOutputHandler {


//	my $template="FT   %-8s %6i %6i       %s\n";
	public String SwissRow(String type, String value, int start, int end, String comment) {
		String output=type + "   ";
		if (start>0) {
			output+=value + "        ".substring(0,(8-value.length()));
			String num = "" + start;
			output += " " + "      ".substring(0,6-num.length()) + num;
			num = "" + end;
			output += " " + "      ".substring(0,6-num.length()) + num;
			if (comment.length()>0)
				output += "       " + comment ;
		} else {
			output += value;
		}
		return output+ "\n";
	}

	public void printPrediction(String pred, String name) {
		pred=pred.replaceAll("-","");
		String output = SwissRow("ID",name,0,0,"");
		String longPred ="";
		int ix=0;
		int start=0;
		char label ='%'; // Any unknown label
		while (ix<=pred.length()) {
			char labHere = (ix<pred.length()? pred.charAt(ix):'%');
			if (label!=labHere) {
				if (label=='n') {
					longPred += SwissRow("FT","REGION",start,ix,"N-REGION.");
				} else if (label == 'h') {
					longPred += SwissRow("FT","REGION",start,ix,"H-REGION.");
				} else if (label == 'c') { 
					longPred += SwissRow("FT","REGION",start,ix,"C-REGION.");
					longPred = SwissRow("FT","SIGNAL",1,ix,"") + longPred;
				} else if (label == 'C') { 
					// Do nothing
				} else if (label == 'O'||label == 'o') { 
					if (start==1 && ix==pred.length()) {
						longPred += SwissRow("FT","TOPO_DOM",start,ix,"CYTOPLASMIC.");	
					} else {
					    longPred += SwissRow("FT","TOPO_DOM",start,ix,"NON CYTOPLASMIC.");
					}
				} else if (label == 'i') { 
					longPred += SwissRow("FT","TOPO_DOM",start,ix,"CYTOPLASMIC.");
				} else if (label == 'M') { 
					longPred += SwissRow("FT","TRANSMEM",start,ix,"");
				}
				if (label != 'C')
					start = ix +1;
				label = labHere;
			}
			ix++;
		}
		output += longPred + "//\n";
		System.out.println(output);
	}
}
