/*
 * HomologHMM 1.04
 * (c) Lukas K�ll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.hmmdecode;

import java.io.*;
import java.util.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.seq.io.*;
import se.ki.cgb.anhmmfile.*;
import se.ki.cgb.labeledhmm.*;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.IllegalSymbolException;
/**
 * Abstract class to print labeled output
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.6 $
 */
public class MacsimOutputHandler extends OutputHandler {

	/* (non-Javadoc)
	 * @see se.ki.cgb.labeledhmm.shortPredHandler#printSequence(org.biojava.bio.seq.Sequence)
	 */
	public void printSequence(Sequence seq) throws IOException {
		
 
		int len = seq.length();
		
		String infoStr = tag("accession",seq.getName()) + "\n";
		infoStr += tag("nid",seq.getName()) + "\n";
		infoStr += tag("ec","0.0.0.0") + "\n";
		infoStr += tag("group","0") + "\n";
		Hashtable preds = LabeledFastaFormat.getLabels(seq);
		Enumeration keyenum = preds.keys();
		String key = "";
		while (keyenum.hasMoreElements()) {
			key = (String) keyenum.nextElement();
			if (key.startsWith("?")) {
				String pred = (String) preds.get(key);
				switch(key.charAt(1)) {
					case 'V':
						infoStr += tag("ftable",getPrediction(pred,"VITERBI")) + "\n";
						break;
				    case 'M':
						infoStr += tag("ftable",getPrediction(pred,"MAX PLP")) + "\n";
						break;
				    case 'O':
						infoStr += tag("ftable",getPrediction(pred,"OPT ACCURACY")) + "\n";
						break;
				    case '0':
						infoStr += tag("ftable",getPrediction(pred,"1-BEST")) + "\n";
						break;
				    case '1':
						infoStr += tag("ftable",getPrediction(pred,"2-BEST")) + "\n";
						break;
					default: break;
				}
			}
		}
		infoStr += tag("length",String.valueOf(len)) + "\n";
		infoStr += tag("weight","100") + "\n";		
	    
		String outStr = tag("seq-name",seq.getName()) + "\n";
		outStr += tag("seq-info",infoStr) + "\n";

		
		SymbolTokenization tokenization = null;
		try {
			tokenization = ProteinTools.getAlphabet().getTokenization("token");
		}
        catch (BioException e) {
        }		
        String residues = "";
		try {
			for(int i = 0; i < len; i++) {
				residues += tokenization.tokenizeSymbol(seq.symbolAt(i+1));
			}
		} catch (IllegalSymbolException e) {residues += "-";}
		outStr += tag("seq-data",residues) + "\n";
        outStr = tag("sequence",outStr,"seq-type","Protein");
        System.out.println(outStr);
	}

	public String getPrediction(String pred, String ftype) {
		pred=pred.replaceAll("-","");
		String longPred ="";
		int ix=0;
		int start=0;
		char label ='%'; // Any unknown label
		while (ix<=pred.length()) {
			char labHere = (ix<pred.length()? pred.charAt(ix):'%');
			if (label!=labHere) {
				if (label=='c') {
					longPred += tag("fitem",
					    	tag("ftype",ftype) +
							tag("fstart","1") + 
							tag("fstop",String.valueOf(ix)) +
							tag("fcolor","3") +
							tag("fscore","0") +
							tag("fnote","SIGNAL PEPTIDE")
			            )+"\n"; // SwissRow("FT","SIGNAL",1,ix,"") + longPred;
				} else if (label == 'O'||label == 'o') { 
					longPred += tag("fitem",
					    	tag("ftype",ftype) +
							tag("fstart",String.valueOf(start)) + 
							tag("fstop",String.valueOf(ix)) +
							tag("fcolor","1") +
							tag("fscore","0") +
							tag("fnote","TRANSLOCATED LOOP")
			            )+"\n"; // SwissRow("FT","DOMAIN",start,ix,"NON CYTOPLASMIC.");
				} else if (label == 'i') { 
					longPred += tag("fitem",
					    	tag("ftype",ftype) +
							tag("fstart",String.valueOf(start)) + 
							tag("fstop",String.valueOf(ix)) +
							tag("fcolor","2") +
							tag("fscore","0") +
							tag("fnote","CYTOPLASMIC LOOP")
			            )+"\n"; // SwissRow("FT","DOMAIN",start,ix,"CYTOPLASMIC.");
				} else if (label == 'M') { 
					longPred += tag("fitem",
					    	tag("ftype",ftype) +
							tag("fstart",String.valueOf(start)) + 
							tag("fstop",String.valueOf(ix)) +
							tag("fcolor","0") +
							tag("fscore","0") +
							tag("fnote","TRANSMEMBRANE")
			            )+"\n"; // SwissRow("FT","TRANSMEM",start,ix,"");
				}
				if (label != 'C')
					start = ix +1;
				label = labHere;
			}
			ix++;
		}
		return longPred;
	}
    
    public void printInit() {
		System.out.println("<?xml version=\"1.0\"?>");	
		System.out.println("<!DOCTYPE macsim SYSTEM \"http://www-bio3d-igbmc.u-strasbg.fr/macsim.dtd\">");	
		System.out.println("<macsim>");	
		System.out.println("<alignment>");	
		System.out.println(tag("aln-name","Phobius Predictions"));	
    }
 
    public void printTail() {
		System.out.println("</alignment>");	
		System.out.println("</macsim>");	
    }

    
    protected String tag(String tagName, String content) {
    	return "<" + tagName + ">" + content + "</" + tagName + ">";
    }
    
    protected String tag(String tagName, String content, String xtra, String val) {
		return "<" + tagName + " " + xtra + "=\"" + val +"\">" + content + "</" + tagName + ">";
    }
}
