/*
 * HomologHMM 1.04
 * (c) Lukas K�ll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.hmmdecode;

import java.io.*;
import java.net.*;
import org.biojava.bio.dp.*;
import org.biojava.bio.seq.*;
import se.ki.cgb.anhmmfile.*;
import se.ki.cgb.labeledhmm.*;
/**
 * Class to handle a prediction session
 * with phobius
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.12 $
 */
public class Phobius extends Run {

	public static String PH_VER = "1.04";

	public static void main(String[] args) throws Exception {
		
		printGreater();
		int nargs=0;
		boolean poly=false;
		boolean best_def=true;
		boolean best=false;
		boolean optacc=false;
		boolean maxplp=false;
		boolean viterbi=false;
		String altModel=null;
		URL url=null;
		String queryFile="";
		OutputHandler.setInstance(new LongOutputHandler());
		Constraints constraints = null;
		
		for (int i=0;i<args.length;i++) {
			if (args[i].equals("-h") || args[i].equals("-?")) {
				printUsage();
				System.exit(0);
			} else if (args[i].equals("-f")) {
				altModel=args[++i];
			} else if (args[i].equals("-v")) {
				viterbi=true;
				best_def=false;
			} else if (args[i].equals("-m")) {
				maxplp = true;
				best_def=false;
			} else if (args[i].equals("-o")) {
				optacc = true;
				best_def=false;
			} else if (args[i].equals("-n")) {
				best = true;
			} else if (args[i].equals("-p") || args[i].equals("-poly") ) {
				poly=true;
				optacc = true;
				best_def=false;
			} else if (args[i].equals("-s") || args[i].equals("-short")) {
				OutputHandler.setInstance(new ShortOutputHandler());
			} else if (args[i].equals("-l") || args[i].equals("-long")) {
				OutputHandler.setInstance(new LongOutputHandler());
			} else if (args[i].equals("-r") || args[i].equals("-raw")) {
				OutputHandler.setInstance(new FastaOutputHandler());
			} else if (args[i].equals("-x") || args[i].equals("-xml")) {
				OutputHandler.setInstance(new MacsimOutputHandler());
			} else if (args[i].equals("-c")) {
				if (constraints==null) constraints = new Constraints();
				while ((i+1<args.length)&&constraints.setConstraint(args[i+1])) {
					i++;
				}
			} else {
				if (nargs==0) queryFile = args[i];
				nargs++;
			}
		}
		if (nargs>1) {
			System.err.println("Too many arguments given");
			System.exit(-1);		
		}
		best |= best_def;
		if (altModel==null){
			ClassLoader cl = Phobius.class.getClassLoader();
			if(cl == null)cl = ClassLoader.getSystemClassLoader();
	 		url = cl.getResource("phobius.model");
	 		if (url==null) {
				System.err.println("Could not locate phobius.model in the installation directory");
				System.err.println("Please copy you licenced version of the file to the same directory");
				System.err.println("the jphobius script.");
				System.exit(-1);
 			}		
		}
		MarkovModel model =null;
		try {
			BufferedReader in;
			if (altModel==null){
				in = new BufferedReader(new InputStreamReader(url.openStream()));
			} else {
				System.err.println("Read ANHMM File "+ altModel);
				in = new BufferedReader(new FileReader(altModel));
			}
			model = AnReader.getInstance().parseStream(in);
			in.close();
		} catch (Exception e) {
			System.err.println("Error ocured while reading the modelfile.");
			System.err.println("Got the following StackTrace:");
			e.printStackTrace();
			System.exit(-1);
		}
		AlignedDP dp = new AlignedDP(model,constraints);
		// Read the sequences
		Sequence [] seqArr = readSequences(queryFile,poly);
		dp.go(seqArr, poly, optacc, maxplp, viterbi, 0,(best?1:0));
		System.exit(0);
	}

	private static void printUsage() {
		System.err.println("usage:	 jphobius [-poly] [-l] [-s] [-r ] input");
		System.err.println("              cat input | jphobius [-poly] [-l] [-s] [-r ]");
		System.err.println("              jphobius -h");		
		System.err.println();
		System.err.println("              where input is a fasta file");
		System.err.println();
		System.err.println("option	-poly Prediction of a fasta alignment");
		System.err.println("option	-l    Long output (default)");
		System.err.println("option	-s    Short output");
		System.err.println("option	-x    Macsim xml output");
		System.err.println("option	-r    Raw output (anhmm style)");
		System.err.println("option	-m    Maximum PLP prediction");
		System.err.println("option	-o    Optimal accuracy prediction");
		System.err.println("option	-v    Viterbi prediction");
		System.err.println("option	-n    1-best prediction");
		System.err.println();
	}

	private static void printGreater() {
		System.err.println("jPhobius version " +PH_VER);
		System.err.println("based on Phobius (c) Lukas Kall, Anders Krogh and Erik Sonnhammer 2004");
		System.err.println("and HomologHMM ver " + HH_VER + " (c) Lukas Kall 2005");
	}

}
