/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.hmmdecode;

import se.ki.cgb.labeledhmm.LabeledOutputHandler;

/**
 * Class to print phobius short output
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.5 $
 */
public class ShortOutputHandler extends LabeledOutputHandler {

	static protected int NAME_LEN = 20;

	public void printPrediction(String pred, String name) {
		pred=pred.replaceAll("-","");
		String output = name +
				"                                                                              ".substring(0,NAME_LEN - name.length());
		String shortPred = "";
		boolean sp =false;
		int tm = 0;
		int ix=0;
		int start=0;
		char label ='%'; // Any unknown label
		while (ix<=pred.length()) {
			char labHere = (ix<pred.length()? pred.charAt(ix):'%');
			if (label!=labHere) {
				if (label=='n') {
					shortPred += label;
					sp = true;
				} else if (label == 'h') {
					shortPred += "" + start + '-' + ix;
				} else if (label == 'c') { 
					shortPred += label;
				} else if (label == 'C') { 
					shortPred += "" + (ix-1) + '/' + ix;
				} else if (label == 'O') { 
					shortPred += 'o';
				} else if (label == 'o') { 
					shortPred += 'o';
				} else if (label == 'i') { 
					shortPred += 'i';
				} else if (label == 'M') { 
					shortPred += "" + start + '-' + ix;
					tm++;
				}
				label = labHere;
				start = ix +1;
			}
			ix++;
		}
		if (shortPred=="o") {shortPred="i";}
		String segs = "" + tm;
		output += "   ".substring(0, (3-segs.length())) + segs;
		output += (sp?"  Y":"  N") + " " + shortPred;
		System.out.println(output);
	}
	
	public void printInit() {
		String name = "Name";
		String output = name +
				"                                                                              ".substring(0,NAME_LEN - name.length());
		output += " TM SP Prediction";
		System.out.println(output);
	}
}
