/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import java.util.*;
import org.biojava.bio.symbol.*;
import org.biojava.bio.dp.onehead.*;

/**
 * Single-head DP cursor over an underlying matrix.
 * The cursor "skipps" gaps
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */
public class AlignedMatrixCursor implements DPCursor {
	private static final Symbol gap = AlphabetManager.getGapSymbol();
	private Symbol currentRes;
	private Symbol lastRes;
	private Iterator symIterator;
	private final SingleDPMatrix matrix;
	private final int dir;
	private int currentIndex;
	private int lastIndex;
	protected int gaps;

	public int length() {
		return matrix.symList()[0].length() + 2;
	}

	public SymbolList symList() {
		return matrix.symList()[0];
	}

	public Symbol currentRes() {
		return currentRes;
	}

	public Symbol lastRes() {
		return lastRes;
	}

	public double[] currentCol() {
		return matrix.scores[currentIndex];
	}

	public double[] lastCol() {
		return matrix.scores[lastIndex];
	}

	public void advance() {
		doadvance();
	}

	protected void postadvance() {
		if (gaps > 0) {
			for (int ix = lastIndex + dir; ix != currentIndex; ix += dir) {
/*				for (int row = 0; row < matrix.states().length; row++) {
					matrix.scores[ix][row] =
						(matrix.scores[lastIndex][row] * (ix - lastIndex)
							+ matrix.scores[currentIndex][row]
								* (currentIndex - ix))
							/ (currentIndex - lastIndex);
				} */
				Arrays.fill(matrix.scores[ix], -Math.log( matrix.states().length));
			}
			gaps = 0;
		}
	}

	protected void doadvance() {
		lastRes = currentRes;
		lastIndex = currentIndex;
		gaps = 0;
		while (symIterator.hasNext()) {
			currentRes = (Symbol) symIterator.next();
			currentIndex += dir;
			if (currentRes.getName().length()>2) // Not a gap
				break;
			gaps++;
		}
		if (currentRes.getName().length()<=2 && !symIterator.hasNext()) {
			currentRes = gap;
			currentIndex += dir;
		}
	}

	public boolean canAdvance() {
//		postadvance();
		return symIterator.hasNext();
//		return symIterator.hasNext() || currentRes != gap;
	}

	public AlignedMatrixCursor(
		SingleDPMatrix matrix,
		Iterator symIterator,
		int dir)
		throws IllegalArgumentException {
		this.symIterator = symIterator;
		this.gaps = 0;
		this.currentRes = gap;
		this.lastRes = gap;
		this.matrix = matrix;
		this.dir = dir;
		this.currentIndex = (dir == 1) ? 0 : length() - 1;
	}
}
