/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.symbol.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.dp.*;
import org.biojava.bio.dp.onehead.*;

/**
 * Single-head DP cursor over an alignment.
 * The cursor "skipps" gaps
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.5 $
 */
public class AlignmentCursor implements DPCursor {
	private static final Symbol gap = AlphabetManager.getGapSymbol();
    private Sequence [] sequences;
	private Symbol currentRes;
	private Symbol lastRes;
	private final int dir;
	private int currentIndex;
	private int lastNoGap;
	private double [] currentC;
	private double [] lastC;

	public int length() {
		return sequences[0].length();
	}

	public int currentIndex() {
		return currentIndex;
	}

	public SymbolList symList() {
		return sequences[0];
	}

	public Symbol currentRes() {
		return currentRes;
	}

	public Symbol [] currentResidues() {
		Symbol [] syms = new Symbol [sequences.length];
		try {
			for (int i=0;i<syms.length;i++) {
				syms[i]=sequences[i].symbolAt(currentIndex);
			}
		}
		catch (IndexOutOfBoundsException e) {
			Symbol [] gapl={gap};
			return gapl;
		}
		return syms;
	}

	public Symbol lastRes() {
		return lastRes;
	}

	public double[] currentCol() {
		return currentC;
	}

	public double[] lastCol() {
		return lastC;
	}

	public void advance() {
		lastRes = currentRes;
// uncomment these lines
/*		currentIndex += dir;
		try {
			currentRes = (Symbol) sequences[0].symbolAt(currentIndex);
		} catch (IndexOutOfBoundsException e) {
			currentRes = gap;
		} */
// comment away these lines for including gaps in querry sequence
		while (canAdvance()) {
			currentIndex += dir;
			try {
				currentRes = (Symbol) sequences[0].symbolAt(currentIndex);
			} catch (IndexOutOfBoundsException e) {
				currentRes=gap;
				break;				
			}
			if (currentRes.getName().length()>2) // Not a gap
				break;
		}
		if (currentRes.getName().length()<=2 && canAdvance()) {
			currentRes = gap;
			currentIndex += dir;
		}
// end comment away
		double [] v = lastC;
		lastC = currentC;
		currentC = v;
//		System.out.println("Pos = " + currentIndex);
	}

	public boolean canAdvance() {
		return (dir == 1) ? currentIndex<lastNoGap:currentIndex>lastNoGap;
	}

	public AlignmentCursor(State [] states,Sequence [] seqs, int dir)
		throws IllegalArgumentException {
		this.sequences = seqs;
		this.currentRes = gap;
		this.lastRes = gap;
		this.dir = dir;
		this.currentIndex = (dir == 1) ? 0 : length()-1;
		this.lastNoGap = (dir == 1) ? length():1;
		this.currentC = new double[states.length];
		this.lastC = new double[states.length];
		while (seqs[0].symbolAt(lastNoGap).getName().length()<=2) {
			lastNoGap-=dir;
		}
	}
}
