/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import java.util.*;
import org.biojava.bio.seq.*;
import org.biojava.bio.symbol.*;

/** This class implements the Heinkoff and Heinkoff weighting scheme
 * without taking in account any columns where sequence contains a gap.
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */
public class ConservedHenikoffWeights extends WeightScheme {

	protected ConservedHenikoffWeights() {
		super();
	}

	/** Calculate weights acording to the Henikoff and Henikoff
	 */
	public double [] getWeights(Sequence [] align) {
		double [] weights = new double[align.length];
    	if (align.length==0) return weights;
//		Symbol [] syms = new Symbol[align.length];
//		int [] freq = new int[align.length];
		HashMap freq = new HashMap(); 
       	for (int i=1; i<=align[0].length();i++) {
            boolean conservedColumn = true;
			for (int j=0;j<align.length;j++) {
				Symbol sym = align[j].symbolAt(i);
				if (sym.getName().length()==3) {
					if (freq.containsKey(sym)) {
						int times = ((Integer) freq.get(sym)).intValue() + 1;
						freq.put(sym,new Integer(times));
					} else {
						freq.put(sym,new Integer(1));
					}
				} else {
					conservedColumn = false;
					break;
				}
			}
			if (conservedColumn) {
				double numSym = freq.size();
				for (int j=0;j<align.length;j++) {
					Symbol sym = align[j].symbolAt(i);
					if (sym.getName().length()==3) {
						int times = ((Integer) freq.get(sym)).intValue();
						weights[j] += 1.0/(numSym*times);				
					}
				}    		
				freq.clear();
			}
    	}
    	double sum = 0;
		for (int j=0;j<align.length;j++) sum += weights[j];
		if (sum>0.0) {
			for (int j=0;j<align.length;j++) weights[j]/=sum;		     		
		} else {
			java.util.Arrays.fill(weights,1.0/align.length);
		}
		return weights;
	}

}
