/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */

/*
 * Created on Nov 9, 2005
 *
 */
package se.ki.cgb.labeledhmm;

import java.util.*;

import org.biojava.bio.seq.Sequence;

/** This class holds and calculates the posterior label probabilities of an sequence or alignment.
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.1 $
 */

public class Constraints {

	protected HashMap constraints;
	protected boolean [][] masks;
	protected boolean [][] adjustedMasks;
	protected boolean mapped = false;
	
	public Constraints() {
		constraints = new HashMap();
	}

    public void setConstraint(int pos,String label) {
    	Integer p = new Integer(pos);
        if (!constraints.containsKey(p)) constraints.put(p,new HashSet());
        ((Set)constraints.get(p)).add(label);
    }

    public boolean setConstraint(String arg) {
		if (arg.matches("[a-zA-Z]_([Cc]|[0-9]+(-[0-9]+)?)")) {
			String[] p = arg.split("_");
			String[] pp = p[1].split("-");
			if (pp[0].charAt(0)=='c' || pp[0].charAt(0)=='C') {
				setCtermConstraint(p[0]);
			} else {
				int first = Integer.parseInt(pp[0]) - 1;
				int last = (pp.length==1?first:Integer.parseInt(pp[1])-1);
				for (int j=first;j<=last;j++) {
					setConstraint(j,p[0]);
				}
			}
			return true;
		}
		return false;

    }

    
    public void setCtermConstraint(String label) {
        if (!constraints.containsKey("C")) constraints.put("C",new HashSet());
        ((Set)constraints.get("C")).add(label);
    }

    
    public void mapConstraints(int seqlen, int numStates, char [] labels, int [][] labelIx2states) {
		if (masks==null) masks = new boolean[seqlen][];
		Iterator keys = constraints.keySet().iterator();
		while(keys.hasNext()) {
			Object key = keys.next();
			int i = Integer.class.isInstance(key)?((Integer)key).intValue():seqlen-1;
		  	if (masks[i]==null) {
				masks[i]= new boolean[numStates];
				Arrays.fill(masks[i],false);
			}
			Iterator it = ((Set)constraints.get(key)).iterator();
			while (it.hasNext()) {
				String lab = (String) it.next();
				int labIx=0;
				while (labIx<labels.length) {
					if (lab.charAt(0)==labels[labIx]) {
						int [] s = labelIx2states[labIx];
						for (int j=0;j<s.length;j++) {
							masks[i][s[j]] = true;
						}
					}
					labIx++;
				} 
			}
		}
		adjustedMasks=masks;
    	mapped=true;
    }
    
    public void constrain(int pos,double[] values) {
    	if (mapped && pos<adjustedMasks.length && adjustedMasks[pos]!=null) {
     		for(int i=0;i<adjustedMasks[pos].length;i++) {
    			if (!adjustedMasks[pos][i]) values[i]=0.0;
    		}
    	}
    }

    public void adjust(Sequence seq) {
    	if (!mapped) throw new Error("Not initiated properly");
    	int len = seq.length();
    	int [] map = new int[len];
    	int j=0;
    	while (seq.symbolAt(j+1).getName().length()<=2) {j++;}
    	for (int i=0;i<=j;i++) map[i]=j;
    	int lastOk = j++;
    	for (;j<len;j++) {
    		if (seq.symbolAt(j+1).getName().length()>2) {
    			map[j]=j;
    			lastOk=j;
    		} else {
    			map[j]=lastOk;
    		}
    	}
		adjustedMasks = new boolean[masks.length][];
    	
    	for (int i=0;i<len;i++) {
    		if (masks[i]!=null) adjustedMasks[map[i]]=masks[i];
     	}
    }

}	

