/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.symbol.*;
/**
 * Holds the forward (alpha) and backward (beta) probabilities
 * for full state probability calculations
 *  * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */
public class FBMatrix {

	public final double [][] alfa; // (symbol,state)
	public final double [][] beta;
	public final double [] c;
	public final int [] g2ung;
	public final int [] ung2g;
	public double score;
	protected int seqlen;
	protected int ungappedlen;
    protected int statelen;
    protected SymbolList sequence;

	/**
	 * 
	 */
	public FBMatrix(SymbolList seq,int statelen) {
		this.sequence = seq;
		this.seqlen = seq.length();
		this.statelen = statelen;
		this.g2ung = new int[seqlen];
		int gaps=0, pos=0;
		for (int i = 0; i < seqlen; i++) {
			Symbol sym;
			try {
				sym = seq.symbolAt(i+1);
			} catch (IndexOutOfBoundsException e) {
				sym = AlphabetManager.getGapSymbol();
			}

			if (sym==AlphabetManager.getGapSymbol() || sym.getName().length()<3) {
				g2ung[i] = -1;
				gaps++; 
			} else {
				g2ung[i] = pos;
				pos++;
			}
		}
	    this.ungappedlen = pos;
		this.ung2g = new int[pos];	    
		for (int i = 0; i < seqlen; i++) {
			if (g2ung[i]>=0) {
				ung2g[g2ung[i]]=i;
			}
		}
		this.alfa = new double[pos][statelen];
		this.beta = new double[pos][statelen];
		this.c = new double[pos + 1];
	}
	
	static protected double [] gammaRet;
	
	double [] getGamma(int pos) {
		if (pos<0 || pos>seqlen || g2ung[pos] < 0) 
			return null;
		int seqpos=g2ung[pos];
		if (gammaRet==null) {			
			gammaRet = new double[statelen];
		}
	    double[] gamma = gammaRet;
		for (int state =0;state < statelen; state++) {
			gamma[state]=alfa[seqpos][state]*beta[seqpos][state]/c[seqpos];
			if (gamma[state]<0 || gamma[state]>1) {
				System.err.println("Probability " + gamma[state] + " detected");
			}
		}
		return gamma;
	}

	/**
	 * @return
	 */
	public int getUngappedLen() {
		return ungappedlen;
	}

}
