/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.seq.Sequence;

/** 
 * This class implements a flat weighting scheme (all sequences weighted equally).
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */
public class FlatWeights extends WeightScheme {

	public FlatWeights() {
		super();
	}
	public double[] getWeights(Sequence[] align) {
		double [] weights = new double[align.length];
		java.util.Arrays.fill(weights,1.0/align.length);
		return weights;
	}

}
