/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import java.util.*;

/** This class hold an N-best hypothisis.
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
public class Hypothesis implements Comparable {

	static AlignedDP dp;
	protected int lastSwitch;
	protected char label;
	protected int labelIx;
	protected String labeling;
	protected double logScore;
	double cmpScore;
	public double [] newCol;
	public double [] oldCol;
	boolean [] alive;

	/**
	 * 
	 */
	public Hypothesis(int nStates,int nLabels) {
		super();
		lastSwitch = 0;
		label = ' ';
		labelIx = -1;
		labeling="";
		alive = new boolean [nLabels];
		Arrays.fill(alive,false);
		newCol = new double [nStates];
		oldCol = new double [nStates];
		oldCol[0]=1.0;
		logScore=0.0;
	}

	public void move(int newLabelIx) {
		if (labelIx!= newLabelIx) {
			lastSwitch = labeling.length();
			labelIx= newLabelIx;
			label = dp.labels[labelIx];
		}
		labeling += label;
		double [] tmp = oldCol;
		oldCol=newCol;
		newCol=tmp;
		Arrays.fill(newCol,0.0);
		int j=0;
		int[] save = dp.labelIx2states[labelIx];
		double c =0.0;
		for (int i=0;i<newCol.length;i++) {
			if (j>=save.length || i<save[j]) {
				oldCol[i]=0.0;
			} else {
				c += oldCol[i];
				j++;
			}
		}
		if (c>0.0)
			for (int i=0;i<save.length;i++) {
				oldCol[save[i]] /= c;
			}
		logScore += Math.log(c);
		Arrays.fill(alive,false);
	}

	public Hypothesis(Hypothesis other,int newLabelIx) {
		super();
		// First copy
		lastSwitch = other.lastSwitch;
		label = other.label;
		labelIx = other.labelIx;
		labeling=new String (other.labeling);
		alive = new boolean [other.alive.length];
		Arrays.fill(alive,false);
		newCol = new double [other.newCol.length];
		oldCol = new double [other.oldCol.length];
		logScore=other.logScore;
		lastSwitch = other.lastSwitch;
		// now do a move
		if (labelIx!= newLabelIx) {
			lastSwitch = labeling.length();
			labelIx= newLabelIx;
			label = dp.labels[labelIx];
		}
		labeling += label;
		int[] save = dp.labelIx2states[labelIx];
		double c =0.0;
		for (int i=0;i<save.length;i++) {
			oldCol[save[i]] = other.newCol[save[i]];
			c += oldCol[save[i]];
		}
		if (c>0.0)
			for (int i=0;i<save.length;i++) {
				this.oldCol[save[i]] /= c;
			}
		logScore += Math.log(c);
	}
	
	public void initNorm() {
		double c =0.0;
		for (int i = 0; i<this.oldCol.length;i++) {
			c += oldCol[i];			
		}
		for (int i = 0; i<this.oldCol.length;i++) {
			oldCol[i] /= c;			
		}
		logScore += Math.log(c);
	}
		
	public void setCompareState(int i) {
		this.cmpScore = this.logScore + Math.log(this.newCol[i]); 
	}

	public void finishUp() {
		this.logScore += Math.log(this.newCol[0]);
		if (this.newCol[0]>0.0)
			this.newCol[0]=1.0;
		this.cmpScore = this.logScore;
	}

   	public int compareTo(Object arg0) {
   		// We want the Hypothesis to be sortet in decending order
		return Double.compare(((Hypothesis)arg0).cmpScore,this.cmpScore);
		// return Double.compare(this.cmpScore,((Hypothesis)arg0).cmpScore);
	}
	
	public final String getLabeling() {
		return labeling;
	}

}
