/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import java.io.IOException;
import java.util.*;
import org.biojava.bio.seq.Sequence;
import se.ki.cgb.anhmmfile.LabeledFastaFormat;

/**
 * Abstract class to print labeled output
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
abstract public class LabeledOutputHandler extends OutputHandler {

	/* (non-Javadoc)
	 * @see se.ki.cgb.labeledhmm.shortPredHandler#printSequence(org.biojava.bio.seq.Sequence)
	 */
	public void printSequence(Sequence seq) throws IOException {
		Hashtable preds = LabeledFastaFormat.getLabels(seq);
		Enumeration keyenum = preds.keys();
		String key = "";
		while (!key.startsWith("?") && keyenum.hasMoreElements()) {
			key = (String) keyenum.nextElement();
		}
		if (key.length()>0) {
			String pred = (String) preds.get(key);
			printPrediction(pred,seq.getName());
		}
	}

    abstract public void printPrediction(String pred, String name) ;
    
}
