/*
 * HomologHMM 1.04
 * (c) Lukas K�ll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.seq.*;
import java.io.*;

/**
 * Abstract Singleton Class to handle prediction output. 
 * In this shape it prints labeld fasta records (like anhmm)
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.4 $
 */
abstract public class OutputHandler {

	protected static OutputHandler outputHandler = null;
    
	public static OutputHandler getInstance() throws Exception {
		if (outputHandler==null)
			throw new Exception("No instance of OutputHandler registered");
		return outputHandler;
	}

	public static void setInstance(OutputHandler oh) {
		outputHandler=oh;
	}
	
	public void printInit() {
		// Default implementation: Do nothing
	}

	abstract public void printSequence(Sequence seq) throws IOException;
 
    public void printTail() {
    }

}
