/*
 * HomologHMM 1.04
 * (c) Lukas Kll
 * Distributable under GPL license.
 * See terms of license at gnu.org.
 */
package se.ki.cgb.labeledhmm;

import org.biojava.bio.seq.*;
/** Abstract class for implementing different weight schemes.
 * the class as well implements a factory of WeightSchemes.
 * @author Lukas.Kall@cgb.ki.se
 * @version $Revision: 1.3 $
 */
abstract public class WeightScheme {


	public static final int FLAT = 0;
	public static final int GAPPED_HENIKOFF = 1;
	public static final int UNGAPPED_HENIKOFF = 2;
	public static final int CONSERVED_HENIKOFF = 3;
	public static final int EDDY_HENIKOFF = 4;
	public static final int IGNORE_HENIKOFF = 5;
    protected static WeightScheme inst=null;

	protected WeightScheme() {}

	static public void selectScheme(int scheme) {
		switch (scheme) {
			case FLAT: 									inst = new FlatWeights(); break;
			case GAPPED_HENIKOFF:			inst = new HenikoffWeights(); break;
			case UNGAPPED_HENIKOFF:	inst = new NoGapHenikoffWeights(); break;
			case CONSERVED_HENIKOFF:	inst = new ConservedHenikoffWeights(); break;
			case EDDY_HENIKOFF:				inst = new EddyHenikoffWeights(); break;
			case IGNORE_HENIKOFF:			inst = new IgnoreGapsHenikoffWeights(); break;
			default: System.err.println("Scheme not implemented");
		}
	}

	static public WeightScheme getInstance() {
		if (inst==null) {
			inst = new EddyHenikoffWeights();
		}
		return inst;
	}

    public abstract double [] getWeights(Sequence [] align);
}
